<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Save;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Post\PostSaveTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class PostSaveBuilder implements InterfacePostSaveSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitPostSaveSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            PostSaveTable::SAVED_POST_ID             => '',
            PostSaveTable::SAVED_BY_USER_ID          => '',
            PostSaveTable::SAVED_TO_COLLECTION_ID    => '0',

            PostSaveTable::STAMP_REGISTRATION        => System::isoDateTime(),
            PostSaveTable::STAMP_LAST_UPDATE         => System::isoDateTime(),
        );
    }

    public function dispense(): PostSaveModel
    {
        return PostSaveModel::createFromData(
            array(
                // saved post id

                PostSaveTable::SAVED_POST_ID => $this -> savedPostId

                ?? $this -> defaultValues[PostSaveTable::SAVED_POST_ID],

                // saved by user id

                PostSaveTable::SAVED_BY_USER_ID => $this -> savedByUserId

                ?? $this -> defaultValues[PostSaveTable::SAVED_BY_USER_ID],

                // saved to collection id

                PostSaveTable::SAVED_TO_COLLECTION_ID => $this -> savedToCollectionId

                ?? $this -> defaultValues[PostSaveTable::SAVED_TO_COLLECTION_ID],

                // stamp registration

                PostSaveTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[PostSaveTable::STAMP_REGISTRATION],

                // stamp last update

                PostSaveTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[PostSaveTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
